package gov.va.vinci.dart.biz;

import java.util.List;

import gov.va.vinci.dart.common.SingletonShim;
import gov.va.vinci.dart.common.exception.ObjectNotFoundException;
import gov.va.vinci.dart.common.exception.ValidationException;
import gov.va.vinci.dart.common.test.BusinessIntegrationTest;
import gov.va.vinci.dart.service.DartObjectFactory;

import org.testng.Assert;
import org.testng.annotations.BeforeTest;
import org.testng.annotations.Test;

public class TestLocation extends BusinessIntegrationTest {
	@BeforeTest
	public void setup() {
		SingletonShim.getBean(DartObjectFactory.class);
	}

	@Test
	public void testOne() throws Exception {

		try {
			Location.findById(0);
			Assert.fail("Expected ObjectNotFoundException");
		} catch (ObjectNotFoundException e) {}
		
		 List<Location> locationList =Location.listAll();
		 
		 Assert.assertNotNull(locationList);
		 Assert.assertTrue(locationList.size() > 0);
		 
	}
	
	@Test
	public void testTwo() throws Exception {
		try {
			Location.findByName(null);
			Assert.fail("Expected ValidationException");
		} catch (ValidationException e) {}

		try {
			Location.findByName("");
			Assert.fail("Expected ValidationException");
		} catch (ValidationException e) {}

		try {
			Location.findByName("123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890");
			Assert.fail("Expected ValidationException");
		} catch (ValidationException e) {}

		// find somebody to search for
		 List<Location> locationList = Location.listAll();
		 
		 Assert.assertNotNull(locationList);
		 Assert.assertTrue(locationList.size() > 0);
		 
		Location loc = Location.findByName(locationList.get(0).getName());
		Assert.assertNotNull(loc);
		Assert.assertTrue(locationList.get(0).equals(loc));
		 
	}
	
	@Test
	public void testThree() throws Exception {

		// find somebody to search for
		List<Location> locationList = Location.listAll();
		 
		Assert.assertNotNull(locationList);
		Assert.assertTrue(locationList.size() > 0);
		 
		Location loc = Location.findById(locationList.get(0).getId());
		Assert.assertNotNull(loc);
		Assert.assertTrue(locationList.get(0).equals(loc));
	}

	@Test
	public void testFour() throws Exception {

		// find somebody to search for
		List<Location> locationList = Location.listAll();
		 
		Assert.assertNotNull(locationList);
		Assert.assertTrue(locationList.size() > 0);
		 
		Location loc = Location.findById(locationList.get(0).getId());
		Assert.assertNotNull(loc);
		Assert.assertTrue(locationList.get(0).equals(loc));

		Assert.assertTrue(loc.hashCode() > 0);
		Assert.assertEquals(loc.compareTo(loc), 0);
		Assert.assertTrue(loc.equals(loc));
		Assert.assertFalse(loc.equals(null));
		
		Location loc2 = locationList.get(1);
		Assert.assertNotNull(loc2);
		Assert.assertNotEquals(loc2, loc);
		Assert.assertFalse(loc.equals(loc2));
		Assert.assertNotEquals(loc.compareTo(loc2), 0);
	}
}
